#ifndef _APPLICATION_H
#define _APPLICATION_H

/*-----------------------------------------------------------------------------

    MCU pins final connection:

    pin 1 - PTA2 / IR Receiver - input only;
    pin 2 - PTA3 / PWR_Control - output only;
    pin 3 = Vdd  / +1.8V to +5.0V
    pin 4 = Vss  / GND
    pin 5 - PTA5 / SCL - I2C
    pin 6 - PTA4 / SDA - I2C
    pin 7 - PTA1 / STBY Button
    pin 8 - PTA0 / GPIO_RF

-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
/* Definitions */

#define SDA_PIN         PTAD_PTAD4
#define SDAPIN          4
#define SCL_PIN         PTAD_PTAD5
#define SCLPIN          5
#define GPIO_RF         PTAD_PTAD0          // for normal user mode;
#define BUTTON          PTAD_PTAD1          // for normal user mode;
#define RC5_PIN         PTAD_PTAD2          // for normal user mode;
#define PWR_PIN         PTAD_PTAD3          // Power Pin Control;
#define I2C_MASK        PTAD_PTAD4_MASK | PTAD_PTAD5_MASK
#define SCL_MASK        PTAD_PTAD5_MASK
#define BUTTON_MASK     KBIPE_KBIPE1_MASK
#define RC5_PIN_MASK    KBIPE_KBIPE2_MASK   // for normal user mode;
#define IIC_MASK        KBIPE_KBIPE4_MASK   // SDA line goes down first;
#define GPIO_MASK       KBIPE_KBIPE0_MASK
//------------------------------------------
#define MY_I2C_ADDR     0xA0        // my own IIC slave address;

#define OFF             1           // for Power Pin Control;
#define ON              0           // for Power Pin Control;
#define RUN             1
#define SLEEP           0

//-----------------------------------------------------------------------------
/* IR Address and Command table */

enum
{
    ADDR1 = 0,
    ADDR2 = 1,
    ADDR3 = 3,  //*** all SW;
    ADDR4 = 5,
    ADDR5 = 6,
    ADDR6 = 8,
    ADDR7 = 0xA,
    ADDR8 = 0xC,
    ADDR9 = 0x11,
    ADDR10 = 0x14,
    ADDR11 = 0x16,
    ADDR12 = 0x1A
} valid_Address;

enum
{
    CMD_ON1 = 0,
    CMD_ON2 = 1, //***SW1
    CMD_ON3 = 2,
    CMD_ON4 = 3,
    CMD_ON5 = 4,
    CMD_ON6 = 5,
    CMD_ON7 = 6,
    CMD_ON8 = 7, //***SW2
    CMD_ON9 = 8,
    CMD_ON10 = 9,
    CMD_ON11 = 0x35  //***SW3
} valid_CommamdON;

enum
{
    CMD_OFF1 = 0x0C  //***SW4
} valid_CommamdOFF;

//-----------------------------------------------------------------------------
/* Global variables */

#pragma DATA_SEG MY_RAM

volatile byte temp, count, mode, Address, Command;
volatile byte bit_length, r_w, RX_data, TX_data, IR_data, user_data;
volatile byte address_valid, command_ON, command_OFF;

#pragma DATA_SEG DEFAULT

//-----------------------------------------------------------------------------
/* Function declarations */
void MCU_init(void); /* Device initialization function declaration */
void Init_Variables(void);
void IR_receive(void);
void I2C_Read(void);
void STBY_Button(void);
void Delay(byte del);
void Wait1ms(void);
void WaitNms(byte del);
void Compare_IR(void);
void Compare_I2C(void);
void Go_sleep(void);

//-----------------------------------------------------------------------------



#endif /* _APPLICATION_H */
